#!/bin/bash

if [ ! -e /sys/class/hwmon/hwmon0/device/pwm1 ]; then
  exit 1
fi

# Spin the Fan at max for 10s
#echo 255 > /sys/class/hwmon/hwmon0/device/pwm1
#sleep 10

# Slow the fan to minimum
echo 20 > /sys/class/hwmon/hwmon0/device/pwm1

LEVEL=20
PWM=20
INCLEVEL=1

while [ true ]; do
  TEMP=`cat /sys/class/hwmon/hwmon0/device/temp2_input`

  #  echo TEMP=${TEMP} PWM=${PWM} LEVEL=${LEVEL} > /tmp/level
  #  echo TEMP=${TEMP} PWM=${PWM} LEVEL=${LEVEL}

  if [ ${TEMP} -ge 80000 ]; then
    /sbin/shutdown -h now
    exit
  else
    if [ ${TEMP} -ge 76000 ]; then
      PWM=255
      INCLEVEL=8
    else
      if [ ${TEMP} -ge 75000 ]; then
        PWM=64
        INCLEVEL=4
      else
        if [ ${TEMP} -ge 60000 ]; then
          PWM=$(((${TEMP} - 45000) / 1000))
          INCLEVEL=1
        else
          if [ ${TEMP} -le 55000 ]; then
            PWM=0
          fi
        fi
      fi
    fi
  fi
  sleep 1

  if [ ${PWM} -gt ${LEVEL} ]; then
    LEVEL=$((${LEVEL} + ${INCLEVEL}))
    echo ${LEVEL} > /sys/class/hwmon/hwmon0/device/pwm1
  else
    if [ ${PWM} -lt ${LEVEL} ]; then
      LEVEL=$((${LEVEL} - 1))
      echo ${LEVEL} > /sys/class/hwmon/hwmon0/device/pwm1
    fi
  fi

  #echo $TEMP $LEVEL
done

