#include <stdio.h>
#include "dump-vdr.h"
#include <linux/dvb/frontend.h>


static const char *inv_name [] = {
	"0",
	"1",
	"INVERSION_AUTO"
};

static const char *fec_name [] = {
	"0",
	"12",
	"23",
	"34",
	"45",
	"56",
	"67",
	"78",
	"89",
	"FEC_AUTO"
};


static const char *qam_name [] = {
	"0",
	"16",
	"32",
	"64",
	"128",
	"256",
	"QAM_AUTO"
};


static const char *bw_name [] = {
	"8",
	"7",
	"6",
	"BANDWIDTH_AUTO"
};


static const char *mode_name [] = {
	"2",
	"8",
	"TRANSMISSION_MODE_AUTO"
};

static const char *guard_name [] = {
	"32",
	"16",
	"8",
	"4",
	"GUARD_INTERVAL_AUTO"
};


static const char *hierarchy_name [] = {
	"0",
	"1",
	"2",
	"4",
	"HIERARCHY_AUTO"
};


void vdr_dump_dvb_parameters (FILE *f, fe_type_t type, struct dvb_frontend_parameters *p)
{
	fprintf (f, "%i:", p->frequency / 1000);
	fprintf (f, "I%s", inv_name[p->inversion]);

	switch (type) {
#if 0
/* No idea about these */
	case FE_QPSK:
		fprintf (f, "%i:", p->u.qpsk.symbol_rate);
		fprintf (f, "%s", fec_name[p->u.qpsk.fec_inner]);
		break;

	case FE_QAM:
		fprintf (f, "%i:", p->u.qpsk.symbol_rate);
		fprintf (f, "%s:", fec_name[p->u.qpsk.fec_inner]);
		fprintf (f, "%s", qam_name[p->u.qam.modulation]);
		break;
#endif
	case FE_OFDM:
		fprintf (f, "B%s", bw_name[p->u.ofdm.bandwidth]);
		fprintf (f, "C%s", fec_name[p->u.ofdm.code_rate_HP]);
		fprintf (f, "D%s", fec_name[p->u.ofdm.code_rate_LP]);
		fprintf (f, "M%s", qam_name[p->u.ofdm.constellation]);
		fprintf (f, "T%s", mode_name[p->u.ofdm.transmission_mode]);
		fprintf (f, "G%s", guard_name[p->u.ofdm.guard_interval]);
		fprintf (f, "Y%s", hierarchy_name[p->u.ofdm.hierarchy_information]);
		fprintf (f, ":T:27500");
		break;

	default:
		;
	};
}

void vdr_dump_service_parameter_set (FILE *f, 
				 const char *service_name,
				 fe_type_t type,
				 struct dvb_frontend_parameters *p,
				 int video_pid,
				 uint16_t *audio_pid,
                                 int audio_num,
                                 int service_id)
{
        int i;
        
	fprintf (f, "%s:", service_name);
	vdr_dump_dvb_parameters (f, type, p);
	fprintf (f, ":%i:", video_pid);
	fprintf (f, "%i", audio_pid[0]);
        for (i=1; i<audio_num; i++)
        	fprintf (f, ",%i", audio_pid[i]);        
	fprintf (f, ":0:0:%d:0:0:0", service_id);
	fprintf (f, "\n");
}

