/* 
    interface2.cc for tuxview

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gtk/gtk.h>
#include <DVB.hh>
#include <sys/wait.h>
#include "common.hh"
#include "interface.hh"
#include "interface2.hh"
#include "gtvscreen2.h"
#include "pics.h"


static GtkWidget *win_main, *aspect, *aspects[MAX_DEV], *menubar;
static GtkWidget *CreateToolbar(GtkWidget * vbox_main, Gtvscreen * gwid);

extern GtkWidget *statusbar;
extern int anz_dev;
extern char devices[MAX_DEV][STRSIZE];
Gtvscreen *gwidget;
Gtvscreen *gwidgets[MAX_DEV];
extern gint contextid;
static GtkAccelGroup *a_group;
int current_dev;
static	GtkWidget *toolbar;
static	GtkWidget *toolbars[MAX_DEV];
static	GtkWidget *handlebox;
static	GtkWidget *handleboxes[MAX_DEV];
extern gint XDIM;
extern gint YDIM;

void Add_Accel(GtkWidget * widget, char *szAccel);


static void ch_picture(GtkWidget * widget, gpointer data)
{
	int act,in;

	act = int(GTK_ADJUSTMENT(widget)->value);
	in = GTV_BRIGHT + int(data);
	gtvscreen_set_values(gwidget, in, (gpointer) act);
}

static gint button_press(GtkWidget * widget, GdkEventButton * event,
                         GtkWidget * note)
{

        if (event->button == 3) {
                if (GTK_WIDGET_VISIBLE(note))
                        gtk_widget_hide(note);
                else
                        gtk_widget_show_all(note);
        }


        return TRUE;
}


static GtkWidget *CreatePicWin(char *title, GtkWidget *main_win)
{
        GtkWidget *widget;
        GtkWidget *window;
        GtkWidget *box;
        //GtkWidget *buttonbox;
        GtkObject *adj;
        //GList *items = NULL;
        //GtkTooltips *tooltips;
        //struct video_channel vc;
        //GSList *group = NULL;
        //int ninput;
	int i, val;
	
	char *PicNam[5] = { "Brightness", "Color", "Hue", "Contrast", 
			    "Whiteness" };

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	
	box = gtk_table_new(6, 2, FALSE);
        gtk_object_set_data(GTK_OBJECT(window), "box", box);
        gtk_container_add(GTK_CONTAINER(window), box);
      
        for (i = 0; i < 5; i++) {
		GtkAttachOptions atob;
		atob = GTK_EXPAND;

                widget = gtk_label_new(PicNam[i]);
                gtk_object_set_data(GTK_OBJECT(window), PicNam[i], widget);
                gtk_table_attach(GTK_TABLE(box), widget, 0, 1, i, i + 1,
                                 atob, atob, 0, 0);

                gtvscreen_get_values(gwidget, GTV_BRIGHT + i, &val);
                adj =
                    gtk_adjustment_new(val, 0, 0xFFFF, 1,
                                       (float) i, 1);
                widget = gtk_hscale_new(GTK_ADJUSTMENT(adj));
                gtk_object_set_data(GTK_OBJECT(window), PicNam[i], widget);
                gtk_table_attach(GTK_TABLE(box), widget, 1, 2, i, i + 1,
                                 atob, atob, 0, 0);
                gtk_scale_set_draw_value(GTK_SCALE(widget), FALSE);
                gtk_scale_set_digits(GTK_SCALE(widget), 0);
		gtk_signal_connect(adj, "value_changed",
                                   GTK_SIGNAL_FUNC(ch_picture),
                                   (gpointer) i);

        }
	return window;
}


void set_aspect(GtkWidget * w, gpointer data)
{
	double ratio = double ((int) data) / 10000.0;

	gtvscreen_set_values(gwidget, GTV_CAP,(gpointer)0);

	gtk_aspect_frame_set(GTK_ASPECT_FRAME(aspect), 0.5, 0.5, ratio,
			     FALSE);
	gtvscreen_set_values(gwidget, GTV_CAP,(gpointer)1);
}


void set_norm(GtkWidget * w, gpointer data)
{
	
	gtvscreen_set_values(gwidget, GTV_NORM, (gpointer) data);  
}

// Initialize gtvscreen widget
static Gtvscreen *init_gtvscreen(char *dev, int bpp, int norm, int remote,
			   int onoff, int ch)
{
	Gtvscreen *gw;

	gw = GTVSCREEN(gtvscreen_new_with_dev(dev));


	gtvscreen_set_values(gw, GTV_REMOTE, (gpointer) remote);
	// set remote-access
	if (bpp)
		gtvscreen_set_values(gw, GTV_BPP, (gpointer) bpp);	
	// set bpp
	if (norm)
		gtvscreen_set_values(gw, GTV_NORM, (gpointer) norm);  
	// set tvnorm
	if (onoff)
		gtvscreen_set_values(gw, GTV_CAP, (gpointer) onoff);
	// set on/off 
	if (ch)
		gtvscreen_set_values(gw, GTV_INPUT, (gpointer) ch);
	// set input
	int on=1;
	if (remote == -1) gtvscreen_set_values(gw, GTV_OVL, (gpointer)on);

	return gw;
}


void device_activate(GtkCheckMenuItem *menu, gpointer user_data)
{
	char buf[80];
	int cl = int(user_data);
	ostringstream str(string(buf, 80));
	
	str << _("Device ") << cl << ends;
	status_message(buf);
	
	if(menu->active){
		//int norm;
		int onoff;
		//int bpp;

		if (cl == current_dev) return;
		else current_dev = cl;
		
		gtvscreen_get_values(gwidget, GTV_CAP, &onoff); 
		gtvscreen_set_values(gwidget, GTV_CAP, 0); 

		gtk_widget_hide(toolbar);
		gtk_widget_hide(handlebox);
		gtk_widget_unrealize(GTK_WIDGET(gwidget));
		gtk_widget_hide(GTK_WIDGET(aspect));

		gwidget = gwidgets[cl];
		aspect = aspects[cl];
		toolbar = toolbars[cl];
		handlebox = handleboxes[cl];

		gtk_widget_show(GTK_WIDGET(aspect));
		gtk_widget_realize(GTK_WIDGET(gwidget));
		gtk_widget_show(handlebox);
		gtk_widget_show(GTK_WIDGET(toolbar));

		//gtvscreen_set_values(gwidget, GTV_CAP, (gpointer)onoff); 
	}
}




void init_graphics(int dev, int bpp, int norm, int remote, int onoff,
		   int channel)
{
	GtkWidget *widget;
	GtkWidget *menu, *menuitem;
	GSList *dev_group = NULL;
	static	GtkWidget *vbox;
	//char filen[80];
	char *device;

	if (dev < 0)
		for(int i=0; i < anz_dev; i++){
			stringstream str;
			str << "/dev/video" << i << ends;
			device = (char*) str.str().c_str();
			gwidgets[i] = init_gtvscreen(device, bpp, norm, 
						     remote, 0, channel);
			widget = GTK_WIDGET(gwidgets[i]);
			gtk_widget_show(widget);
			dev = 0;
		}
	else {
		stringstream str;
		str << "/dev/video" << dev << ends;
		dev = 0;
		anz_dev = 1;
		device = (char*) str.str().c_str();
		gwidgets[dev] = init_gtvscreen(device, bpp, norm, 
					     remote, 0, channel);
		widget = GTK_WIDGET(gwidgets[dev]);
		gtk_widget_show(widget);
	}

	current_dev = dev;
	gwidget = gwidgets[dev];
	gtvscreen_set_values(gwidget, GTV_CAP, (gpointer)1); 
	
	

	// create main window
	win_main = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(win_main), "TuxView");
	int maxx,maxy;

        if (a_group == NULL) {
                a_group = gtk_accel_group_new();
                gtk_accel_group_attach(a_group, GTK_OBJECT(win_main));
        }


	gtvscreen_get_values(gwidget,GTV_MAXX,&maxx);
	gtvscreen_get_values(gwidget,GTV_MAXY,&maxy);
	gtk_widget_set_usize(win_main, maxx, maxy);
	gtk_window_set_policy(GTK_WINDOW(win_main), TRUE, FALSE, TRUE);	
	gtk_container_border_width(GTK_CONTAINER(win_main), 0);
	a_group = gwidget->accel_group;
	gtk_accel_group_attach(a_group, GTK_OBJECT(win_main));
	gtk_signal_connect(GTK_OBJECT(win_main), "destroy",
			   GTK_SIGNAL_FUNC(quit), NULL);
	gtk_signal_connect(GTK_OBJECT(win_main), "delete_event",
			   GTK_SIGNAL_FUNC(quit), NULL);


	gtk_widget_show(win_main);

	// create vbox
	vbox = gtk_vbox_new(FALSE, 2+anz_dev*2);
	gtk_container_add(GTK_CONTAINER(win_main), vbox);
	gtk_widget_show(vbox);

	//create menubar  
	menubar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, FALSE, 0);
	gtk_widget_show(menubar);
	menu = CreateBarSubMenu(menubar, _("File"));
	menuitem = CreateMenuItem(menu, _("Quit"), "^q", _("Quit"),
				  GTK_SIGNAL_FUNC(quit), (void *) "quit",
				  a_group);

	if (anz_dev >1){
		menu = CreateBarSubMenu(menubar,_("Device"));
		
		for (int i=0 ; i < anz_dev; i++){
			
			menuitem = gtk_radio_menu_item_new_with_label (
				dev_group, devices[i]);
			dev_group = gtk_radio_menu_item_group 
				(GTK_RADIO_MENU_ITEM (menuitem));
			gtk_widget_show (menuitem);
			gtk_container_add (GTK_CONTAINER (menu), menuitem);
			gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
					    GTK_SIGNAL_FUNC (device_activate),
					    (void *)i);	
			if ( dev == i) 
				gtk_check_menu_item_set_active(
					(GtkCheckMenuItem *)menuitem,
					TRUE);
		}
	}

	menu = CreateBarSubMenu(menubar, _("Aspect"));
	menuitem = CreateMenuItem(menu, "4:3", "", "4:3",
				  GTK_SIGNAL_FUNC(set_aspect),
				  (void *) 13333,a_group);

	menuitem = CreateMenuItem(menu, "16:9", "", "16:9",
				  GTK_SIGNAL_FUNC(set_aspect),
				  (void *) 17777,a_group);


	menu = CreateBarSubMenu(menubar, _("TV-Norm"));
	menuitem = CreateMenuItem(menu, "PAL", "", "PAL",
				  GTK_SIGNAL_FUNC(set_norm),
				  (void *) VIDEO_MODE_PAL,a_group);
	menuitem = CreateMenuItem(menu, "NTSC", "", "NTSC",
				  GTK_SIGNAL_FUNC(set_norm),
				  (void *) VIDEO_MODE_NTSC,a_group);
	menuitem = CreateMenuItem(menu, "SECAM", "", "SECAM",
				  GTK_SIGNAL_FUNC(set_norm),
				  (void *) VIDEO_MODE_SECAM,a_group);

	for (int i=0; i< anz_dev; i++){
		//create handlebox
		handleboxes[i] = gtk_handle_box_new();
		gtk_box_pack_start(GTK_BOX(vbox), handleboxes[i], 
				   FALSE, FALSE, 0);
		
		// create toolbar (duh)
		toolbars[i] = CreateToolbar(handleboxes[i],gwidgets[i]);


		// show handlebox and pack gtvscreen widget
	}
	toolbar = toolbars[dev];
	handlebox = handleboxes[dev];
	gtk_widget_show(handlebox);
	gtk_widget_show(toolbar);

	// create aspect frame
	for(int i=0; i < anz_dev; i++){
		stringstream str;
		str << _("aspect") << i << ends;
		aspects[i] = gtk_aspect_frame_new(NULL, 0.5, 0.5, 
						  1.3333, FALSE);
		gtk_object_set_data(GTK_OBJECT(win_main), str.str().c_str(), 
				    aspects[i]);
		gtk_box_pack_start(GTK_BOX(vbox), aspects[i], TRUE, TRUE, 0);
		gtk_container_add(GTK_CONTAINER(aspects[i]), 
				  GTK_WIDGET(gwidgets[i]));
	}
	aspect = aspects[dev];
	gtk_widget_show(aspect);

	GdkColor black = { 0, 0, 0, 0 };
	gdk_color_alloc(gdk_colormap_get_system(), &black);
	GtkStyle *style, *ostyle;
	ostyle = gtk_widget_get_default_style();
	style = gtk_style_copy(ostyle);
	for (int i = 0; i < 5; i++) {
		style->bg[i] = black;
		style->fg[i] = black;
	}
	gtk_widget_set_style(GTK_WIDGET(win_main), style);

	//create statusbar
	widget = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widget)
				       , GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width(GTK_CONTAINER(widget), 0);
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, FALSE);
	statusbar = gtk_statusbar_new();
	gtk_object_set_data(GTK_OBJECT(win_main), "statusbar", statusbar);
	gtk_widget_show(statusbar);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(widget),
					      statusbar);
	contextid =
	    gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),
					 "Statusbar");
	gtk_statusbar_push(GTK_STATUSBAR(statusbar), contextid,
			   _("Welcome to TuxView"));
	gtk_widget_show(widget);

	gint x,y;
	gdk_window_get_deskrelative_origin(win_main->window, &x, &y);
	gdk_window_move_resize(win_main->window,x,y,XDIM, YDIM);
	
	widget = CreatePicWin("Gtvscreen", win_main);
        gtk_signal_connect(GTK_OBJECT(win_main), "button_press_event",
                           (GtkSignalFunc) button_press, (gpointer) widget);



	gtk_main();
}



static void switches(GtkWidget * widget, gpointer data)
{
	int in;
	int cap;
	int act;

	int l = (int) data;
	if (GTK_WIDGET_VISIBLE(widget)) {
		switch (l) {

			//switch to overlay mode 
		case OVERLAY:
			act =
			    int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			gtvscreen_get_values(gwidget, GTV_OVL, &cap);
			if (act != cap) {
				gtvscreen_set_values(gwidget, GTV_OVL,
						     (gpointer) act);
			}
			break;

			// switch on capturing
		case CAPOO:
			act =
			    int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			gtvscreen_get_values(gwidget, GTV_CAP, &cap);
			if (cap != act) {
				gtvscreen_set_values(gwidget, GTV_CAP,
						     (gpointer) act);
			}
			break;

			// switch to selected input
		case TV:
		case VID1:
		case VID2:
		case VID3:
		case VID4:
			act =
			    int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			if (act) {
				in = l - TV;
				gtvscreen_set_values(gwidget, GTV_INPUT,
						     (gpointer) in);
			}
			break;

		case FULL:
			int isfull;
			gtvscreen_get_values(gwidget, GTV_FULLS, &isfull);
			if (isfull) {
				gtk_aspect_frame_set(GTK_ASPECT_FRAME
						     (aspect), 0.5, 0.5,
						     1.3333, FALSE);
			} else {
				gtk_aspect_frame_set(GTK_ASPECT_FRAME
						     (aspect), 0.5, 0.5,
						     1.3333, TRUE);
			}
			gtvscreen_set_values(gwidget, GTV_FULLS, NULL);
			break;

		default:
			break;

		}
	}
}



void ovrtoggle(GtkWidget * gtv, gpointer data)
{
	int ovl, ovr;
	GtkWidget *tool = (GtkWidget *) data;
	if (GTK_WIDGET_VISIBLE(tool)) {
		ovr =
		    int (gtk_toggle_button_get_active
			 ((GtkToggleButton *) tool));
		gtvscreen_get_values(gwidget, GTV_OVL, &ovl);

		if (ovr != ovl)
			gtk_toggle_button_set_active((GtkToggleButton *)
						     tool, ovl);
	}
}

void captoggle(GtkWidget * gtv, gpointer data)
{
	int cap, car;
	GtkWidget *tool = (GtkWidget *) data;
	if (GTK_WIDGET_VISIBLE(tool)) {
		gtvscreen_get_values(gwidget, GTV_CAP, &cap);
		car =
		    int (gtk_toggle_button_get_active
			 ((GtkToggleButton *) tool));
		if (car != cap)
			gtk_toggle_button_set_active((GtkToggleButton *)
						     tool, cap);
	}
}

void input_change(GtkWidget * gtv, gpointer data)
{
	int in, state;
	GtkWidget **tool = (GtkWidget **) data;
	gtvscreen_get_values(GTVSCREEN(gtv), GTV_INPUT, &in);
	if (GTK_WIDGET_VISIBLE(tool[in])) {
		state =
		    gtk_toggle_button_get_active((GtkToggleButton *)
						 tool[in]);
		if (!state)
			gtk_toggle_button_set_active((GtkToggleButton *)
						     tool[in], TRUE);
	}
}


static GtkWidget *CreateToolbar(GtkWidget * vbox_main, Gtvscreen *gwid)
{
	GtkWidget *tool;
	GtkWidget *pixi;
	GtkWidget *tbar;


	//create the toolbar and add it to the window 
	tbar =
	    gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	gtk_container_add(GTK_CONTAINER(vbox_main), tbar);


	tool = NULL;

	if (gwid->remote != 1) {
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_full);
		tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						   GTK_TOOLBAR_CHILD_BUTTON,
						   NULL,
						   "Full",
						   "Toggle Fullscreen",
						   "f", pixi,
						   (GtkSignalFunc)
						   switches,
						   gpointer(FULL));
		Add_Accel(tool, "f");

		gtk_toolbar_prepend_space(GTK_TOOLBAR(tbar));
	}

	tool = NULL;

	int ninput;
	gtvscreen_get_values(gwid, GTV_NINPUT, &ninput);

	GtkWidget **intool;
	intool = new(GtkWidget *)[ninput];
	// first button of radio box for input switching : tuner
	switch (ninput) {

	case 5:
		// video 4
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_vid4);
		intool[4] =
		    gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						GTK_TOOLBAR_CHILD_RADIOBUTTON,
						tool, "Video4", "Video4",
						"Video4", pixi,
						(GtkSignalFunc) switches,
						gpointer(VID4));
		tool = intool[4];

	case 4:
		// video 3
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_vid3);
		intool[3] =
		    gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						GTK_TOOLBAR_CHILD_RADIOBUTTON,
						tool, "Video3", "Video3",
						"Video3", pixi,
						(GtkSignalFunc) switches,
						gpointer(VID3));
		tool = intool[3];

	case 3:
		// video 2
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_vid2);
		intool[2] =
		    gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						GTK_TOOLBAR_CHILD_RADIOBUTTON,
						tool, "Video2", "Video2",
						"Video2", pixi,
						(GtkSignalFunc) switches,
						gpointer(VID2));
		tool = intool[2];

	case 2:
		// video 1
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_vid1);
		intool[1] =
		    gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						GTK_TOOLBAR_CHILD_RADIOBUTTON,
						tool, "Video1", "Video1",
						"Video1", pixi,
						(GtkSignalFunc) switches,
						gpointer(VID1));
		tool = intool[1];

	case 1:
		pixi = CreateWidgetFromXpm(vbox_main, 
					   (gchar **) xpm_vid0);

		intool[0] =
		    gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						GTK_TOOLBAR_CHILD_RADIOBUTTON,
						tool, "Tuner", "Tuner",
						"Tuner", pixi,
						(GtkSignalFunc) switches,
						gpointer(TV));

		gtk_signal_connect(GTK_OBJECT(gwid), "chinput",
				   GTK_SIGNAL_FUNC(input_change),
				   (gpointer) intool);
		tool = intool[0];

	}

	input_change(GTK_WIDGET(gwid), intool);

	gtk_toolbar_prepend_space(GTK_TOOLBAR(tbar));

	int remote;
	gtvscreen_get_values(gwid, GTV_REMOTE, &remote);

	int covl;
	gtvscreen_get_values(gwid, GTV_COVL, &covl);

	if (remote == 0 && covl) {
		pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_over);
		tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
						   GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
						   NULL,
						   _("Overlay"), _("Overlay"),
						   _("Overlay"), pixi,
						   (GtkSignalFunc)
						   switches,
						   gpointer(OVERLAY));

		gtk_signal_connect(GTK_OBJECT(gwid), "choverlay",
				   GTK_SIGNAL_FUNC(ovrtoggle),
				   (gpointer) tool);
	} else
		gtk_toolbar_prepend_space(GTK_TOOLBAR(tbar));



	// capture button 
	pixi = CreateWidgetFromXpm(vbox_main, (gchar **) xpm_tux2);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(tbar),
					   GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
					   NULL,
					   "capture", "capture", "capture",
					   pixi, (GtkSignalFunc) switches,
					   gpointer(CAPOO));
	gtk_signal_connect(GTK_OBJECT(gwid), "chcapture",
			   GTK_SIGNAL_FUNC(captoggle), (gpointer) tool);

	int onoff=0;
	gtvscreen_get_values(gwid, GTV_CAP, &onoff);
	gtk_toggle_button_set_active((GtkToggleButton *)
				     tool, onoff);

	return tbar;
}

void quit()
{
	int state = 0;
	int isfull;
	gtvscreen_get_values(gwidget, GTV_FULLS, &isfull);
	if (isfull)
		gtvscreen_set_values(gwidget, GTV_FULLS, NULL);

	gtvscreen_set_values(gwidget, GTV_CAP, (gpointer) state);
	gtk_exit(0);
}


void Add_Accel(GtkWidget * widget, char *szAccel)
{
	if (a_group == NULL) {
		a_group = gtk_accel_group_new();
		gtk_accel_group_attach(a_group, GTK_OBJECT(win_main));
	}

	if (szAccel) {
		if (szAccel[0] == '^') {
			gtk_widget_add_accelerator(widget,
						   "clicked",
						   a_group,
						   szAccel[1],
						   GDK_CONTROL_MASK,
						   GTK_ACCEL_VISIBLE);
		} else {
			gtk_widget_add_accelerator(widget,
						   "clicked",
						   a_group,
						   szAccel[0],
						   0, GTK_ACCEL_VISIBLE);
		}
	}

}


