/* 
    channel for Bt848 frame grabber driver

    Copyright (C) 1996,97 Marcus Metzler (mocm@metzlerbros.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _gchannel_h
#define _gchannel_h

#define NLIST 5


#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <DVB.hh>

#include "common.hh"
#define NOTSET -1

/*
 * channel.hh
 */

const int mnamelen = 80;

class gChannel { int freq;
	char name[mnamelen + 1];
	int num;
	uint64_t dvb_num;
      public:
	 gChannel() {
		name[0] = '\0';
		num = -1;
		dvb_num = 0;
	}
	
	gChannel(char *nam, int num) {
		int l = strlen(nam);
		if (l > mnamelen) {
			cerr <<
			    "WARNING: Name too long in channel. Name being truncated"
			    << endl;
			l = mnamelen;
		}
		name[0] = '\0';
		for (int i = 0; i < l; i++) {
			name[i] = nam[i];
		}
		name[l] = '\0';
	}

	gChannel(const Channel & chan, const Transponder & trans,
		 const Lnb & ln);

	inline int &Num() {
		return num;
	} 
	inline uint64_t &DVB_Num() {
		return dvb_num;
	} 
	inline char *Name() {
		return name;
	} 
	
	void SetName(char *nam) {
		int l = strlen(nam);
		if (l > mnamelen) {
			cerr <<
			    "WARNING: Name too long in channel. Name being truncated"
			    << endl;
			l = mnamelen;
		}
		for (int i = 0; i < l; i++) {
			name[i] = nam[i];
		}
		name[l] = '\0';
	}

        friend ostream & operator << (ostream & stream, gChannel & x);
	friend istream & operator >> (istream & stream, gChannel & x);
};


const int channelinc = 50;

class ChannelList { 
	int numchan;
	int maxnumc;
	gChannel *channels;

      public:
	 ChannelList();
	 ChannelList(char *filen);
	~ChannelList() {
		delete(channels);
#ifdef DEBUG
		cerr << _("ChannelList destroyed") << endl;
#endif
	} 
	
	void init(char *filen);
	inline int NumChan() {
		return numchan;
	} 
	inline gChannel & operator() (int i) {
		if (i > numchan || i < 0) {
			cerr << _("Channel ") << i <<
			    _(" does not exist in Channel List") << endl;
			exit(1);
		}
		return channels[i];
	}

	void AddChannel(gChannel & chan);
	void DelChannel(char *name);
	void DelChannel(char *name, int freq);
	void DelChannel(int nb);
	friend ostream & operator << (ostream & stream, ChannelList & x);
};


#endif				/*channel.h */
