############################################################
# Script:  Bot Uptime
# Version: 1.0.0
# Author:  Emeric Lucier Evans
############################################################
# This script will give the bots uptime and some system
# information through a private message, channel message
# or partyline command. Don't let the fact that there are
# so many settings in this script worry you, IT WILL WORK
# EVEN IF YOU JUST LOAD IT STRAIGHT UP. The settings are
# merely for the convenience of customization and each give
# a good explanation of what they do.
#
# This script is based roughly on Ofloo's Simple eggdrop
# uptime script. I initially just started modifying his
# script with features that I wanted, and now have decided
# to completely code my own. The thing I mainly took from
# his are the uptime calculations using Eggdrop's $uptime
# variable and some of the variable settings for the users
# of this script because I'm lazy. So credit goes to Ofloo
# for the basis of this script. Some credit also goes to
# wreck who's strplc function I found very useful for
# allowing people to configure their uptime message's
# format. All credit for retreiving the computer stats
# other than the bot's uptime go to me though!
#
# PLEASE NOTE: The portion of this script that retreives
# CPU information, Memory Usage, etc. may only work on
# most Linux distributions as the information is
# retreived from the /proc folder. On other variations
# of *nix it may return "Unknown" for these particular
# things. I'm told by a friend this would definately
# be the case for *BSD systems.
############################################################

################################
####### Uptime Commands ########
################################
# This lets you set the command for your bots uptime for
# in the channel, in private messages, and in dcc/partyline.
# (ie. pub=channel, msg=private message, dcc=dcc/partyline.)
# PlEASE NOTE: DCC/Partyline commands always have a . in front
# so there is no need to have it in the bind.
set command(pub) "!uptime"
set command(msg) "uptime"
set command(dcc) "uptime"

################################
#### User Flag Requirements ####
################################
# Set this to "-" to allow everyone to use this command. If you
# only want known users to be able to use it it is recommended
# you set it to "h" as this is a flag the bot gives to all
# users by default when they are added.
set uflag "-"

################################
##### Uptime Response Type #####
################################
# Set this to either PRIVMSG or NOTICE depending on whether
# you want the bot to respond by messages or notices. This
# can be set for each type of uptime command except
# DCC/Partyline, which merely uses tcl's putdcc.
set uptimersp(pub) "PRIVMSG"
set uptimersp(msg) "PRIVMSG"

################################
#### Uptime Message Format #####
################################
# Here you can format the message the bot sends for the uptime
# command for each type of uptime command. Please keep in mind
# the DCC/Partyline Response will always look like "Botname
# <your message format>".
# You can also use the following codes in your command:
# %bot - Bot's Nickname
# %uptime - Bot's Uptime
# %os - The operating system your bot is running on.
# %cpuspeed - Your computers processor speed.
# %cpumodel - The type of processor your computer uses.
# %memtotal - The total amount of memory your computer has.
# %memfree - The amount of memory your computer has available.
# %loadavg - The load averages of your box.
#
# PLEASE NOTE: Some shell providers may not want you to use
# %loadavg as this could be used by someone doing a DDoS
# attack to monitor their effectivity. I do not take any
# responsibility for how this can be abused, use it at your
# own peril.
set uptimeformat(pub) "\001ACTION has a total uptime of %uptime and is running %os on a %cpuspeed %cpumodel with %memtotal (%memfree available)."
set uptimeformat(msg) "\001ACTION has a total uptime of %uptime and is running %os on a %cpuspeed %cpumodel with %memtotal (%memfree available)."
set uptimeformat(dcc) "%bot has a total uptime of %uptime and is running %os on a %cpuspeed %cpumodel with %memtotal (%memfree available)."


#### DO NOT EDIT BELOW UNLESS YOU KNOW WHAT YOU'RE DOING ####
bind pub $uflag $command(pub) pub_uptime
bind msg $uflag $command(msg) msg_uptime
bind dcc $uflag $command(dcc) dcc_uptime

proc pub_uptime {nick uhost hand chan arg} {cmd_uptime pub $chan}
proc msg_uptime {nick uhost hand arg} {cmd_uptime msg $nick}
proc dcc_uptime {hand idx arg} {cmd_uptime dcc $idx}
proc strplc {variable old new} {regsub -all -- $old $variable $new fixed ; return $fixed}
proc cmd_uptime {type target} {
	global botnick uptime uptimeformat uptimersp
	set uptimecalc(uptime) [expr [clock seconds]-$uptime]
	set uptimecalc(weeks) [expr $uptimecalc(uptime)/604800]
	set uptimecalc(uptime) [expr $uptimecalc(uptime)-$uptimecalc(weeks)*604800]
	set uptimecalc(days) [expr $uptimecalc(uptime)/86400]
	set uptimecalc(uptime) [expr $uptimecalc(uptime)-$uptimecalc(days)*86400]
	set uptimecalc(hours) [expr $uptimecalc(uptime)/3600]
	set uptimecalc(uptime) [expr $uptimecalc(uptime)-$uptimecalc(hours)*3600]
	set uptimecalc(mins) [expr $uptimecalc(uptime)/60]
	set uptimecalc(uptime) [expr $uptimecalc(uptime)-$uptimecalc(mins)*60]
	set uptimecalc(secs) $uptimecalc(uptime)
	set botuptime ""
	if {$uptimecalc(weeks) >= 1} {append botuptime $uptimecalc(weeks) " week\(s\) "}
	if {$uptimecalc(days) >= 1} {append botuptime $uptimecalc(days) " day\(s\) "}
	if {$uptimecalc(hours) >= 1} {append botuptime $uptimecalc(hours) " hour\(s\) "}
	if {$uptimecalc(mins) >= 1} {append botuptime $uptimecalc(mins) " minute\(s\) "}
	if {$uptimecalc(secs) >= 1} {append botuptime $uptimecalc(secs) " second\(s\)"}
	set os [unames]
	if {[catch {exec cat /proc/cpuinfo | grep "cpu MHz"} cpuspeed]} {set cpuspeed "Unknown"}
	if {[catch {exec cat /proc/cpuinfo | grep "model name"} cpumodel]} {set cpumodel "Unknown"}
	if {[catch {exec cat /proc/meminfo | grep "MemTotal"} memtotal]} {set memtotal "Unknown"}
	if {[catch {exec cat /proc/meminfo | grep "MemFree"} memfree]} {set memfree "Unkown"}
	if {[catch {exec uptime} loadavg]} {set loadavg "Unknown"}
	set cpuspeed "[expr double(round([string map {"cpu MHz		: " ""} $cpuspeed]))]"
	set cpumodel [string map {"model name	: " ""} $cpumodel]
	set memtotal [expr [string map {"MemTotal:       " ""} [string map {" kB" ""} $memtotal]]/1024]
	set memfree [expr [string map {"MemFree:         " ""} [string map {" kB" ""} $memfree]]/1024]
	set loadavg [strplc $loadavg ".+load average: " ""]
	if {$cpuspeed >= 1000} {
		set cpuspeed "[expr $cpuspeed/1000]GHz"
	} else {
		set cpuspeed "[expr round($cpuspeed)]MHz"
	}
	if {$memtotal >= 1024} {
		set $memtotal "[expr $memtotal/1024]GB"
	} else {
		append memtotal "MB"
	}
	if {$memfree >= 1024} {
		set $memfree "[expr $memfree/1024]GB"
	} else {
		append memfree "MB"
	}
	if {$type == "pub"} {
	        set uptimemsg $uptimeformat(pub)
		set uptimemsg [strplc $uptimemsg %bot $botnick]
	        set uptimemsg [strplc $uptimemsg %uptime $botuptime]
	        set uptimemsg [strplc $uptimemsg %os $os]
	        set uptimemsg [strplc $uptimemsg %cpuspeed $cpuspeed]
	        set uptimemsg [strplc $uptimemsg %cpumodel $cpumodel]
	        set uptimemsg [strplc $uptimemsg %memtotal $memtotal]
	        set uptimemsg [strplc $uptimemsg %memfree $memfree]
		set uptimemsg [strplc $uptimemsg %loadavg $loadavg]
		putquick "$uptimersp(pub) $target :$uptimemsg"
	} elseif {$type == "msg"} {
		set uptimemsg $uptimeformat(msg)
		set uptimemsg [strplc $uptimemsg %bot $botnick]
		set uptimemsg [strplc $uptimemsg %uptime $botuptime]
		set uptimemsg [strplc $uptimemsg %os $os]
		set uptimemsg [strplc $uptimemsg %cpuspeed $cpuspeed]
		set uptimemsg [strplc $uptimemsg %cpumodel $cpumodel]
		set uptimemsg [strplc $uptimemsg %memtotal $memtotal]
		set uptimemsg [strplc $uptimemsg %memfree $memfree]
		set uptimemsg [strplc $uptimemsg %loadavg $loadavg]
		putquick "$uptimersp(msg) $target :$uptimemsg"
	} elseif {$type == "dcc"} {
		set uptimemsg $uptimeformat(dcc)
		set uptimemsg [strplc $uptimemsg %bot $botnick]
		set uptimemsg [strplc $uptimemsg %uptime $botuptime]
		set uptimemsg [strplc $uptimemsg %os $os]
		set uptimemsg [strplc $uptimemsg %cpuspeed $cpuspeed]
		set uptimemsg [strplc $uptimemsg %cpumodel $cpumodel]
		set uptimemsg [strplc $uptimemsg %memtotal $memtotal]
		set uptimemsg [strplc $uptimemsg %memfree $memfree]
		set uptimemsg [strplc $uptimemsg %loadavg $loadavg]
		putdcc $target "$uptimemsg"
	}
}

putlog "Bot Uptime 1.0.0 by Emeric Lucifer Evans has been loaded."
